/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
abdomen_score();

/**
 * Performs the abdomen score calculation for the specified models
 */
function abdomen_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = "abdomen";

    let occupants = ["DRIVER"];

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* ABDOMEN_HI_SCORE copies chest */
            let ABDOMEN_HI_SCORE = get_variable_value(status, `CHEST_HI_SCORE`, "int");

            let ABDOMEN_COMPRESSION_HI_LIMIT = 47; // The abdominal compression limit in mm
            let ABDOMEN_COMPRESSION_LO_LIMIT = 65; // The abdominal compression limit in mm
            let ABDOMEN_COMPRESSION_CAPPING_LIMIT = 65; // Capping limit is 65mm (same as lower limit)
            let ABDOMEN_COMPRESSION_GOOD = ABDOMEN_COMPRESSION_HI_LIMIT; //higher performance limit
            let ABDOMEN_COMPRESSION_WEAK = ABDOMEN_COMPRESSION_LO_LIMIT; //lower performance limit

            let max_upp_rib_com = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_VALUE`,
                "float",
                templ
            );
            let max_bottom_rib_com = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_VALUE`,
                "float",
                templ
            );
            let topc = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_SCORE`,
                "float",
                templ
            );
            let botc = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_SCORE`,
                "float",
                templ
            );
            let maxc = Math.max(max_upp_rib_com, max_bottom_rib_com);
            new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_MAX_VALUE`,
                `Result from Automotive Assessments Workflow`,
                maxc.toFixed(3),
                "General",
                false,
                true
            );

            let abdomen_score = Math.min(topc, botc);
            new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_SCORE`,
                `Result from Automotive Assessments Workflow`,
                abdomen_score.toFixed(3),
                "General",
                false,
                true
            );

            new Variable(
                templ,
                `${m}_ABDOMEN_CAPPING_LIMIT`,
                `Result from Automotive Assessments Workflow`,
                maxc > ABDOMEN_COMPRESSION_CAPPING_LIMIT ? "TRUE" : "FALSE",
                "General",
                false,
                true
            );
        }
    }
}

function sliding_scale(val, hi_perf, lo_perf, hi_score, lo_score) {
    var retval = 0.0;

    if (val < hi_perf) retval = hi_score;
    else if (val > lo_perf) retval = lo_score;
    else retval = hi_score + ((val - hi_perf) * (lo_score - hi_score)) / (lo_perf - hi_perf);

    return retval;
}
